<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Route;

Route::post('login', [Driver\Auth\LoginController::class, 'login'])->name('login');

Route::middleware(['auth:driver-api'])->group(function () {
    Route::get('logout', [Driver\Auth\LoginController::class, 'logout'])->name('logout');


    //Profile
    Route::get('profile', [Driver\ProfileController::class, 'index']);
    Route::post('edit_profile', [Driver\ProfileController::class, 'update']);

    //Orders

    Route::get('orders', [Driver\OrderController::class, 'index']);
    Route::get('order_details', [Driver\OrderController::class, 'details']);
    Route::post('order_delivery', [Driver\OrderController::class, 'orderDelivery']);
    
});