<?php

namespace App\Http\Controllers\Client;

use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use App\Http\Requests\Client\CheckProductDetailsRequest;
use App\Models\Product;

class ProductController extends Controller
{
    use ResponsesTrait;
    public function index(Request $request){
        #TODO complete
        $this->lang();
        $products = Product::where(["category_id"=>$request->category_id,'seller_id'=>$request->seller_id])
        ->where([['is_available',1],['quantity','>',0]]);
        if($request->name){
            $products =$products->where('name_ar', 'LIKE', "%{$request->name}%")
            ->orWhere('name_en', 'LIKE', "%{$request->name}%") ;
        }

        $products = $products->select('id' ,$this->name ,$this->description,'price','quantity','main_image','picture')
        ->get();
        return $this->success($products);
    }

    public function details(CheckProductDetailsRequest $request){
        $this->lang();
        $product=Product::whereId($request->id)->with('images:id,product_id,name')
        ->select('id',$this->name ,$this->description ,'price','quantity','main_image','picture')
        ->first();
        return $this->success($product);
    }

}
